/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.base.UserContextInfo;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;

public class VWException
extends Exception
implements Serializable {
    private static final long serialVersionUID = 7479L;
    private static Logger logger = Logger.getLogger("filenet.vw.api");
    private static String m_className = VWException.class.getName();
    protected String key = null;
    protected Object[] args = null;
    protected static Object synchObject = new Object();
    protected static Hashtable propBundleHashTable = new Hashtable(3);
    protected boolean m_bWrappedException = false;
    protected String m_causeDescription = null;
    protected String m_causeClassName = null;
    protected static boolean warned = false;
    private static int MAX_STACK_FRAMES = 10;
    private static String UnknownExceptionString;
    private static String rootCauseString;
    private static String stackFrameAtString;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-07-22 00:14:05 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Lauren Nguyen;5D5845897;laurenng@us.ibm.com (lnguyen) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/7 $";
    }

    public VWException(Throwable cause) {
        super(cause);
        this.m_bWrappedException = true;
        if (cause != null) {
            this.m_causeDescription = cause.getLocalizedMessage();
            this.m_causeClassName = cause.getClass().getName();
        }
    }

    public void setCause(Throwable cause) {
        this.initCause(cause);
        if (cause != null && cause != this) {
            this.m_causeDescription = cause.getLocalizedMessage();
            this.m_causeClassName = cause.getClass().getName();
        }
    }

    public Throwable getRootCause() {
        return VWException.getRealCause(this);
    }

    public String getCauseClassName() {
        return this.m_causeClassName;
    }

    public String getCauseDescription() {
        return this.m_causeDescription;
    }

    public VWException(String aKey, String dummy) {
        super(dummy);
        this.key = aKey;
    }

    public VWException(String aKey, String dummy, Object arg0) {
        super(dummy);
        this.key = aKey;
        this.args = new Object[1];
        this.args[0] = arg0;
    }

    public VWException(String aKey, String dummy, Object arg0, Object arg1) {
        super(dummy);
        this.key = aKey;
        this.args = new Object[2];
        this.args[0] = arg0;
        this.args[1] = arg1;
    }

    public VWException(String aKey, String dummy, Object arg0, Object arg1, Object arg2) {
        super(dummy);
        this.key = aKey;
        this.args = new Object[3];
        this.args[0] = arg0;
        this.args[1] = arg1;
        this.args[2] = arg2;
    }

    public VWException(String aKey, String dummy, Object[] arguments) {
        super(dummy);
        this.key = aKey;
        this.args = arguments;
    }

    public String toString() {
        Throwable t;
        String result = null;
        if (this.m_bWrappedException) {
            return super.getMessage();
        }
        try {
            PropertyResourceBundle prb = VWException.getResourceBundle(this.getClass());
            result = prb.getString(this.key);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (result == null) {
                result = super.getMessage();
            }
            result = MessageFormat.format(result, this.args);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null) {
            result = UnknownExceptionString;
        }
        if ((t = VWException.getRealCause(this)) != null && t != this && result.compareTo(t.toString()) != 0) {
            result = result + "\n" + t.toString();
        }
        return result;
    }

    public String getMessage() {
        return this.toString();
    }

    public String getKey() {
        return this.key;
    }

    public static String getStringFromKey(String theKey) {
        String result = null;
        try {
            PropertyResourceBundle localPrb = VWException.getResourceBundle(VWException.class);
            if (localPrb != null) {
                result = localPrb.getString(theKey);
            }
            localPrb = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    private static URL getResourceURL(Class thisClass, Locale locale) {
        URL choice;
        String method = "getResourceURL";
        String userLang = locale.getLanguage();
        if (logger.isFinest()) {
            logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Locale= " + locale + " Locale language= " + userLang + ", Locale country= " + locale.getCountry());
        }
        if (userLang != null && userLang.equalsIgnoreCase("iw")) {
            userLang = "he";
        }
        if (logger.isFinest()) {
            logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Try to find resource file= " + "VWExceptions_" + userLang + "_" + locale.getCountry());
        }
        if ((choice = thisClass.getResource("VWExceptions_" + userLang + "_" + locale.getCountry())) == null) {
            if (logger.isFinest()) {
                logger.finest(m_className, method, "[WARNING] " + thisClass.getName() + ":  Cannot find resource file= " + "VWExceptions_" + userLang + "_" + locale.getCountry());
            }
            if (userLang != null && userLang.equalsIgnoreCase("nb") || userLang != null && userLang.equalsIgnoreCase("NO")) {
                if (logger.isFinest()) {
                    logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Try to find resource file= " + "VWExceptions_" + "nb_NO");
                }
                if ((choice = thisClass.getResource("VWExceptions_nb_NO")) == null && logger.isFinest()) {
                    logger.finest(m_className, method, "[WARNING] " + thisClass.getName() + ":  Cannot find resource file= " + "VWExceptions_" + "nb_NO");
                }
            } else {
                if (logger.isFinest()) {
                    logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Try to find resource file= " + "VWExceptions_" + userLang);
                }
                choice = thisClass.getResource("VWExceptions_" + userLang);
            }
        }
        if (choice == null) {
            if (logger.isFinest()) {
                logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Try to find resource file= " + "VWExceptions_en_US");
            }
            choice = thisClass.getResource("VWExceptions_en_US");
        }
        if (logger.isFinest()) {
            if (choice != null) {
                logger.finest(m_className, method, "[INFO]Resource file for " + thisClass.getName() + " = " + choice.toString());
            } else {
                logger.finest(m_className, method, "[WARNING] " + thisClass.getName() + ":  Could not find resource file! Locale=" + locale);
            }
        }
        return choice;
    }

    private static String getKeyName(Class theClass, Locale theLocale) {
        return theLocale.toString() + ":" + theClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PropertyResourceBundle getResourceBundle(Class theClass) throws IOException {
        if (theClass == null) {
            return null;
        }
        Object object = synchObject;
        synchronized (object) {
            UserContextInfo userContext = UserContextInfo.get();
            Locale locale = userContext == null ? Locale.getDefault() : userContext.getLocale();
            String key = VWException.getKeyName(theClass, locale);
            PropertyResourceBundle prb = (PropertyResourceBundle)propBundleHashTable.get(key);
            if (prb == null) {
                boolean fromVWException = false;
                URL choice = VWException.getResourceURL(theClass, locale);
                if (choice == null && theClass != VWException.class && (prb = (PropertyResourceBundle)propBundleHashTable.get(VWException.getKeyName(VWException.class, locale))) == null) {
                    choice = VWException.getResourceURL(VWException.class, locale);
                    fromVWException = true;
                }
                if (choice != null) {
                    InputStream in = null;
                    try {
                        in = choice.openStream();
                        prb = new PropertyResourceBundle(in);
                        propBundleHashTable.put(key, prb);
                        if (fromVWException) {
                            propBundleHashTable.put(VWException.getKeyName(VWException.class, locale), prb);
                        }
                    }
                    catch (Exception e) {
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            in = null;
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            return prb;
        }
    }

    public String getLocalizedMessage() {
        return this.toString();
    }

    public static Throwable getRealCause(Throwable t) {
        Throwable c;
        Throwable throwable = c = t == null ? null : t.getCause();
        if (c == null || c == t) {
            return t;
        }
        return VWException.getRealCause(c);
    }

    public static String DescribeThrowableAndItsCause(Throwable t) {
        StringWriter sWriter = new StringWriter(1024);
        PrintWriter out = new PrintWriter(sWriter);
        out.println(t.getLocalizedMessage());
        if (t instanceof NullPointerException) {
            return VWException.DescribeThrowableAndItsCauseWithStackFrames(t, 0);
        }
        Throwable realCause = VWException.getRealCause(t);
        if (realCause != null && realCause != t) {
            out.println(rootCauseString);
            out.println(realCause.getLocalizedMessage());
        }
        return sWriter.getBuffer().toString();
    }

    public static String DescribeThrowableCompletely(Throwable t) {
        StringWriter sWriter = new StringWriter(1024);
        PrintWriter out = new PrintWriter(sWriter);
        t.printStackTrace(out);
        return sWriter.getBuffer().toString();
    }

    public static String DescribeThrowableAndItsCauseWithStackFrames(Throwable t, int maxFrames) {
        StringWriter sWriter = new StringWriter(1024);
        PrintWriter out = new PrintWriter(sWriter);
        out.println(t.getLocalizedMessage());
        StackTraceElement[] trace2 = t.getStackTrace();
        int printMaxFrames = Math.min(Math.max(maxFrames, MAX_STACK_FRAMES), trace2 == null ? 0 : trace2.length);
        for (int i = 0; i < printMaxFrames; ++i) {
            out.println(stackFrameAtString + trace2[i]);
        }
        Throwable realCause = VWException.getRealCause(t);
        if (realCause != null && realCause != t) {
            out.println(rootCauseString);
            out.println(realCause.getLocalizedMessage());
            StackTraceElement[] realCauseTrace = realCause.getStackTrace();
            printMaxFrames = Math.min(Math.max(maxFrames, MAX_STACK_FRAMES), realCauseTrace == null ? 0 : realCauseTrace.length);
            for (int i = 0; i < printMaxFrames; ++i) {
                out.println(stackFrameAtString + realCauseTrace[i]);
            }
        }
        return sWriter.getBuffer().toString();
    }

    static {
        try {
            String s = System.getProperty("filenet.base.logging.Logger.maxStackFrames", "10");
            MAX_STACK_FRAMES = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UnknownExceptionString = new VWString("ex.unknownException", "Unknown Exception").toString();
        rootCauseString = new VWString("ex.rootcause", "Root Cause:").toString();
        stackFrameAtString = new VWString("ex.stackFrameAt", "\tat ").toString();
    }
}

